/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	ConstrainSeparationLineToLine.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT ConstrainSeparationLineToLine(ILine *line1, ILine *line2)
{

//	Creates a LLLinearDim constraint between the two given lines

	START_METHOD("ConstrainSeparationLineToLine")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILLLinearDim *llLinearDim = NULL;
	status = (GetCLASS(LLLinearDim))->CreateLLLinearDim(line1, line2, &llLinearDim);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint = NULL;

	status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint,llLinearDim), &pConstraint);
	CHECK_RETURN_STATUS(status)

	END_METHOD("ConstrainSeparationLineToLine")
}
